<?php declare(strict_types=1);

namespace App\Domains\Profile\Controller;

use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Response;
use App\Domains\Profile\Service\Controller\Update as ControllerService;

class Update extends ControllerAbstract
{
    /**
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function __invoke(): Response|RedirectResponse
    {
        $this->load();

        if ($response = $this->actionPost('update')) {
            return $response;
        }

        $this->meta('title', __('profile-update.meta-title'));

        return $this->page('profile.update', $this->data());
    }

    /**
     * @return array
     */
    protected function data(): array
    {
        return ControllerService::new($this->request, $this->auth, $this->row)->data();
    }

    /**
     * @return \Illuminate\Http\RedirectResponse
     */
    protected function update(): RedirectResponse
    {
        $this->action()->update();

        $this->sessionMessage('success', __('profile-update.success'));

        return redirect()->route('profile.update');
    }
}
