<?php declare(strict_types=1);

namespace App\Domains\Alarm\Controller;

use App\Domains\Alarm\Model\Alarm as Model;
use App\Domains\CoreApp\Controller\ControllerWebAbstract;

abstract class ControllerAbstract extends ControllerWebAbstract
{
    /**
     * @var ?\App\Domains\Alarm\Model\Alarm
     */
    protected ?Model $row;

    /**
     * @param int $id
     *
     * @return \App\Domains\Alarm\Model\Alarm
     */
    protected function row(int $id): Model
    {
        return $this->row = Model::query()
            ->byId($id)
            ->byUserOrManager($this->auth)
            ->firstOr(fn () => $this->exceptionNotFound(__('alarm.error.not-found')));
    }
}
